% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_code.R
\name{extract_javascript_code}
\alias{extract_javascript_code}
\title{Extract JavaScript code from a string}
\usage{
extract_javascript_code(input_string)
}
\arguments{
\item{input_string}{A string containing JavaScript code blocks, typically a response
from an LLM}
}
\value{
A character vector containing the extracted JavaScript code
}
\description{
This function extracts JavaScript code from a string by matching all content between
'```javascript', '```js', '```jsx' and '```'.
}
\examples{
# Simple JavaScript example
text <- "Code:\n```javascript\nconsole.log('Hello');\n```"
extract_javascript_code(text)

# Using 'js' tag
text <- "```js\nconst x = 42;\n```"
extract_javascript_code(text)

# Using 'jsx' tag for React
text <- "```jsx\n<div>Hello World</div>\n```"
extract_javascript_code(text)

# Multiple blocks with different tags
response <- "
Frontend code:
```javascript
function fetchData() {
    return fetch('/api/data')
        .then(response => response.json());
}
```

React component:
```jsx
const MyComponent = () => {
    const [data, setData] = useState([]);

    useEffect(() => {
        fetchData().then(setData);
    }, []);

    return (
        <div>
            {data.map(item => <p key={item.id}>{item.name}</p>)}
        </div>
    );
};
```

Node.js backend:
```js
const express = require('express');
const app = express();

app.get('/api/data', (req, res) => {
    res.json([{id: 1, name: 'Item 1'}]);
});

app.listen(3000);
```
"
codes <- extract_javascript_code(response)
length(codes) # Returns 3

}
