% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipalities.R
\docType{data}
\name{Cernosice_PZ_cz}
\alias{Cernosice_PZ_cz}
\title{Municipal Election Data: Cernosice (PZ, CZ)}
\format{
An object of class \code{data.frame} with 971 rows and 14 columns.
}
\source{
The dataset was compiled primarily from official election results published by
the Czech Statistical Office. Additional contextual or verification information
(such as post-election roles) was obtained from publicly available municipal
records.
\itemize{
\item \href{https://www.volby.cz/index_en.htm}{Czech Statistical Office},
\item \href{https://www.mestocernosice.cz/}{Municipality website}
}
}
\usage{
Cernosice_PZ_cz
}
\description{
A dataset containing individual-level candidacy records from municipal
elections in the municipality of Cernosice (district Praha-zapad, Czech
Republic).
}
\details{
\tabular{ll}{
   \strong{Dataset overview:} \tab  \cr
   Municipality: \tab Cernosice \cr
   District: \tab Praha-zapad \cr
   Country: \tab Czech Republic \cr
   Number of elections: \tab 8 \cr
   Elections covered: \tab 1994, 1998, 2002, 2006, 2010, 2014, 2018, 2022 \cr
   Number of candidacies (rows): \tab 971 \cr
   Note: \tab \href{https://www.mestocernosice.cz/}{Municipality website} \cr
}
}
\section{Description of variables}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   elections \tab Election identifiers (numeric) \cr
   candidate \tab Candidate's full name (character) \cr
   list_name \tab Name of the candidate list (character) \cr
   list_pos \tab Candidate's position on the list (numeric) \cr
   pref_votes \tab Number of preferential votes (numeric) \cr
   elected \tab Logical; TRUE if candidate was elected \cr
   nom_party \tab Nominating party (character) \cr
   pol_affil \tab Political affiliation (character) \cr
   mayor \tab TRUE if elected mayor \cr
   dep_mayor \tab TRUE if elected deputy mayor \cr
   board \tab TRUE if member of the executive board \cr
   gov_support \tab TRUE if supported the local government \cr
   elig_voters \tab Number of eligible voters (numeric) \cr
   ballots_cast \tab Number of ballots cast (numeric) \cr
}


Each record describes one candidate's run for office, including their candidate
list affiliation, position on the list, nominating party, political affiliation,
number of preferential votes, and whether they were elected or held specific
positions (mayor, deputy mayor, member of the executive body).

The dataset also includes contextual election-level information, such as the
number of eligible voters and ballots cast, which can be used to calculate
voter turnout and related indicators. These variables appear only once per
election and constituency (they may be stored in a single candidate row for
that election/constituency)
}

\examples{
# Basic inspection
str(Cernosice_PZ_cz)

# Example of a basic continuity diagram (unformatted version)
\donttest{plot_continuity(Cernosice_PZ_cz, elections = "2010-")}
}
\references{
\itemize{
\item Muller, K. B. (2018). \emph{Dobre vladnuti ve verejnem nezajmu. Lokalni politicke}
\emph{elity jako klicovi akteri demokratizace?} (Good Governance in Public Disinterest.
Local Political Elites as Key Actors of Democratization?).
Prague: Sociologicke nakladatelstvi (SLON).
[\href{https://karolinum.cz/en/books/muller-dobre-vladnuti-ve-verejnem-nezajmu-25018}{Publisher link}]
\item Muller, K. B. (2018). Dobre vladnuti a jeho akteri v postkomunistickem
happyvillu aneb jak rozhodovat v zajmu tech, kteri nejsou slyset (Good
governance and its actors in a post-communist happyville. How to govern in
favour of those who remain salient). \emph{Acta Politologica} 10(1), 57-85.
[\href{https://acpo.fsv.cuni.cz/ACPONEN-56-version1-acpo_2018_01_04.pdf}{Full text}]
\item Formackova, M. (2013). Vyvoj mistni samospravy v obci Cernosice (The Development
of Local Government in the Municipality of Cernosice). Master thesis.
Czech University of Life Sciences Prague.
[\href{https://theses.cz/id/l5jf3r/?lang=en}{Full text}]
\item Hausmannova, H. (2011). \emph{Obcanska spolecnost a politicke elity na komunalni urovni}
(Civil Society and Political Elites on Local Level). Bachelor thesis.
Prague University of Economics and Business.
[\href{https://vskp.vse.cz/english/27042}{Full text}]
}
}
\keyword{datasets}
