% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_r_selector_utils.R
\name{find_graphics_plot_grob}
\alias{find_graphics_plot_grob}
\title{Utility functions for robust selector generation in Base R plots}
\usage{
find_graphics_plot_grob(grob, element_type, plot_index = NULL)
}
\arguments{
\item{grob}{The grob tree to search (typically from ggplotify::as.grob())}

\item{element_type}{The element type to search for (e.g., "rect", "lines", "points")}

\item{plot_index}{Optional plot index to match (for multipanel layouts)}
}
\value{
The name of the first matching grob, or NULL if not found
}
\description{
These functions provide a robust way to find grob elements and generate
CSS selectors, independent of panel structure or hardcoded values.
Find grob by element type pattern
}
\details{
Searches recursively through a grob tree to find a grob whose name matches
the pattern: graphics-plot-<number>-<element_type>-<number>
}
