% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphql-introspection.R
\name{meetupr_schema_queries}
\alias{meetupr_schema_queries}
\title{Explore available query fields in the Meetup GraphQL API}
\usage{
meetupr_schema_queries(schema = meetupr_schema())
}
\arguments{
\item{schema}{The schema object obtained from \code{meetupr_schema()}.}
}
\value{
A tibble with details about each query field, including:
\describe{
\item{field_name}{Name of the query field}
\item{description}{Human-readable description of the field}
\item{args_count}{Number of arguments the field accepts}
\item{return_type}{The GraphQL type returned by this field}
}
}
\description{
This function retrieves the root-level query fields available in the Meetup
GraphQL API. These are the entry points for data fetching (e.g.,
\code{groupByUrlname}, \code{event}, etc.).
}
\examples{
\dontrun{
# List all available queries
queries <- meetupr_schema_queries()

# Find group-related queries
queries |>
  dplyr::filter(grepl("group", field_name, ignore.case = TRUE))
}

}
