% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{convert_pos}
\alias{convert_pos}
\alias{convert_width}
\title{Convert from unit A to unit B}
\usage{
convert_pos(xa, ya, yb)

convert_width(xa, ya, yb)
}
\arguments{
\item{xa}{A numeric vector specifying widths/positions in unit A.}

\item{ya, yb}{A numeric vector specifying the positions of at least two points in unit A /
unit B.}
}
\value{
A numeric vector of values converted from unit A to unit B.
}
\description{
Converts positions/widths from unit A to unit B. If the direction of units  A
and B is reversed, the width's sign will be reversed as well. To keep  widths
strictly positive, wrap the result with \code{abs()}.
}
\examples{
ya <- c(244, 246, 248, 250, 252)
yb <- c(15, 10, 5, 0, -5)
convert_width(c(2, 4, 8), ya, yb)
convert_pos(c(247, 249), ya, yb)
}
\author{
2024-2025 Tobias Schmidt: initial version.
}
