% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_tidy_api.R
\name{add_category}
\alias{add_category}
\title{Add a category to a recipe}
\usage{
add_category(recipe, category, description = "")
}
\arguments{
\item{recipe}{A Recipe object.}

\item{category}{Character category name or RecipeCategory object.}

\item{description}{Character. Description for the category (used when
\code{category} is a string). Defaults to empty.}
}
\value{
The modified Recipe object (invisibly for piping).
}
\description{
Pipe-friendly function to add a category to a Recipe object.
Accepts either a category name (string) or a
\code{\link{RecipeCategory}} object.
}
\examples{
r <- recipe(
  name = "Example", user = "Test",
  svy = survey_empty(type = "ech", edition = "2023"),
  description = "Example recipe"
)
r <- r |>
  add_category("labor_market", "Labor market indicators") |>
  add_category("income")

}
\seealso{
\code{\link{remove_category}}, \code{\link{recipe_category}},
\code{\link{default_categories}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
