% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_client.R
\name{api_register}
\alias{api_register}
\title{Register a new user}
\usage{
api_register(
  name,
  email,
  password,
  user_type = "individual",
  institution = NULL
)
}
\arguments{
\item{name}{Display name}

\item{email}{Email address}

\item{password}{Password}

\item{user_type}{One of \code{"individual"},
\code{"institutional_member"}, \code{"institution"}}

\item{institution}{Institution name
(required for \code{"institutional_member"})}
}
\value{
Invisibly, the API response (list with \code{ok},
\code{token}, \code{user}).
}
\description{
Create an account on the metasurvey API. On success the JWT
token is stored automatically via \code{options(metasurvey.api_token)}.
}
\examples{
\dontrun{
configure_api("https://metasurvey-api.example.com")
api_register("Ana Garcia", "ana@example.com", "s3cret")
}
}
\seealso{
Other api-auth: 
\code{\link{api_login}()},
\code{\link{api_logout}()},
\code{\link{api_me}()},
\code{\link{api_refresh_token}()},
\code{\link{configure_api}()}
}
\concept{api-auth}
