% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{bake_recipes}
\alias{bake_recipes}
\title{Bake recipes}
\usage{
bake_recipes(svy)
}
\arguments{
\item{svy}{Survey object}
}
\value{
Survey object with all recipes applied
}
\description{
Bake recipes
}
\examples{
\donttest{
dt <- data.table::data.table(id = 1:20, x = rnorm(20), w = runif(20, 0.5, 2))
svy <- Survey$new(
  data = dt, edition = "2023", type = "demo",
  psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w")
)
r <- recipe(
  name = "Demo", user = "test", svy = svy,
  description = "Demo recipe"
)
svy <- add_recipe(svy, r)
processed <- bake_recipes(svy)
}
}
\seealso{
Other recipes: 
\code{\link{Recipe-class}},
\code{\link{add_recipe}()},
\code{\link{explore_recipes}()},
\code{\link{get_recipe}()},
\code{\link{print.Recipe}()},
\code{\link{publish_recipe}()},
\code{\link{read_recipe}()},
\code{\link{recipe}()},
\code{\link{save_recipe}()},
\code{\link{steps_to_recipe}()}
}
\concept{recipes}
\keyword{survey}
