% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_app.R
\name{explore_recipes}
\alias{explore_recipes}
\title{Launch the Recipe Explorer Shiny App}
\usage{
explore_recipes(port = NULL, host = "127.0.0.1", launch.browser = TRUE)
}
\arguments{
\item{port}{Integer port number, or NULL for automatic.}

\item{host}{Character. The host to listen on. Defaults
to \code{"127.0.0.1"} for local use. Set to
\code{"0.0.0.0"} for server deployments (Railway,
etc.).}

\item{launch.browser}{Logical. Open the app in a browser?}
}
\value{
NULL (called for side effect of launching the app).
}
\description{
Opens an interactive web application to explore, search, and browse
metasurvey recipes with visual documentation cards. Supports user
registration and login via MongoDB Atlas.
}
\examples{
\dontrun{
# Local / RStudio viewer
explore_recipes()

# Server deployment (Railway, Docker, etc.)
explore_recipes(host = "0.0.0.0", port = 3838, launch.browser = FALSE)
}

}
\seealso{
Other recipes: 
\code{\link{Recipe-class}},
\code{\link{add_recipe}()},
\code{\link{bake_recipes}()},
\code{\link{get_recipe}()},
\code{\link{print.Recipe}()},
\code{\link{publish_recipe}()},
\code{\link{read_recipe}()},
\code{\link{recipe}()},
\code{\link{save_recipe}()},
\code{\link{steps_to_recipe}()}
}
\concept{recipes}
