% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelSurvey.R
\name{get_implantation}
\alias{get_implantation}
\title{Get implantation survey from a rotating panel}
\usage{
get_implantation(RotativePanelSurvey)
}
\arguments{
\item{RotativePanelSurvey}{A \code{RotativePanelSurvey} object from which
to extract the implantation survey}
}
\value{
A \code{Survey} object containing the implantation survey with all
its metadata, data, and design configuration
}
\description{
Extracts the implantation (baseline) survey from a RotativePanelSurvey
object. The implantation survey represents the first data collection wave
and is essential for establishing the baseline and structural
characteristics of the panel.
}
\details{
The implantation survey is special in a rotating panel because:
\itemize{
\item Establishes the baseline: Defines initial characteristics of all
panel units
\item Contains the full sample: Includes all units that will participate
in the different panel waves
\item Defines temporal structure: Establishes rotation and follow-up
patterns
\item Configures metadata: Contains information about periodicity,
key variables, and stratification
\item Serves as tracking reference: Basis for unit tracking in
subsequent waves
}

This function is essential for analysis requiring:
\itemize{
\item Temporal comparisons from the baseline
\item Analysis of the complete panel structure
\item Configuration of longitudinal models
\item Evaluation of sampling design quality
}
}
\examples{
impl <- Survey$new(
  data = data.table::data.table(id = 1:5, w = 1),
  edition = "2023", type = "test", psu = NULL,
  engine = "data.table", weight = add_weight(annual = "w")
)
fu <- Survey$new(
  data = data.table::data.table(id = 1:5, w = 1),
  edition = "2023_01", type = "test", psu = NULL,
  engine = "data.table", weight = add_weight(annual = "w")
)
panel <- RotativePanelSurvey$new(
  implantation = impl, follow_up = list(fu),
  type = "test", default_engine = "data.table",
  steps = list(), recipes = list(), workflows = list(), design = NULL
)
get_implantation(panel)

}
\seealso{
\code{\link{get_follow_up}} for obtaining follow-up surveys
\code{\link{extract_surveys}} for extracting multiple surveys by criteria
\code{\link{load_panel_survey}} for loading rotating panels
\code{\link{workflow}} for analysis with the implantation survey

Other panel-surveys: 
\code{\link{PoolSurvey}},
\code{\link{RotativePanelSurvey}},
\code{\link{extract_surveys}()},
\code{\link{get_follow_up}()}
}
\concept{panel-surveys}
\keyword{panel-survey}
