% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{step_remove}
\alias{step_remove}
\title{Remove variables from survey data (step)}
\usage{
step_remove(
  svy,
  ...,
  vars = NULL,
  .copy = use_copy_default(),
  comment = "Remove variables",
  use_copy = deprecated(),
  lazy = lazy_default(),
  record = TRUE
)
}
\arguments{
\item{svy}{A Survey or RotativePanelSurvey object}

\item{...}{Unquoted variable names to remove, or a character vector}

\item{vars}{Character vector of variable names to remove.
Alternative to \code{...} for programmatic use.}

\item{.copy}{Whether to operate on a copy (default: \code{use_copy_default()})}

\item{comment}{Descriptive text for the step for
documentation and traceability (default \code{"Remove variables"}).}

\item{use_copy}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{.copy} instead.}

\item{lazy}{Internal. Whether to delay execution (default \code{lazy_default()}).}

\item{record}{Internal. Whether to record the step (default \code{TRUE}).}
}
\value{
Survey object with the specified variables
removed (or queued for removal).
}
\description{
Creates a step that removes one or more variables
from the survey data when baked.
}
\details{
\strong{Lazy evaluation (default):} By default, steps are recorded but
\strong{not executed} until \code{\link[=bake_steps]{bake_steps()}} is called.

Variables can be specified in two ways:
\itemize{
\item \strong{Unquoted names:} \code{step_remove(svy, age, income)}
\item \strong{Character vector:} \code{step_remove(svy, vars = c("age", "income"))}
}

Variables that don't exist in the data produce a warning
(not an error), allowing pipelines to be robust to missing columns.
}
\examples{
dt <- data.table::data.table(
  id = 1:5, age = c(25, 30, 45, 50, 60),
  w = rep(1, 5)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "ech",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)
svy2 <- step_remove(svy, age)
svy2 <- bake_steps(svy2)
"age" \%in\% names(get_data(svy2)) # FALSE
}
\seealso{
Other steps: 
\code{\link{bake_steps}()},
\code{\link{get_steps}()},
\code{\link{step_compute}()},
\code{\link{step_filter}()},
\code{\link{step_join}()},
\code{\link{step_recode}()},
\code{\link{step_rename}()},
\code{\link{step_validate}()},
\code{\link{view_graph}()}
}
\concept{steps}
