% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{step_validate}
\alias{step_validate}
\title{Validate data during the step pipeline}
\usage{
step_validate(
  svy,
  ...,
  .action = c("stop", "warn"),
  .min_n = NULL,
  .copy = use_copy_default(),
  comment = "Validate step"
)
}
\arguments{
\item{svy}{A Survey or RotativePanelSurvey object}

\item{...}{Logical expressions evaluated against the data. Each must
return a logical vector with one value per row. Named expressions
use the name in error messages; unnamed expressions use the deparsed
code. Examples: \code{income > 0}, \code{!is.na(age)},
\code{sex \%in\% c(1, 2)}.}

\item{.action}{What to do when a check fails: \code{"stop"} (default)
raises an error, \code{"warn"} issues a warning and continues.}

\item{.min_n}{Minimum number of rows required. Checked before
row-level expressions.}

\item{.copy}{Whether to operate on a copy (default:
\code{use_copy_default()})}

\item{comment}{Descriptive text for the step for documentation
and traceability (default \code{"Validate step"}).}
}
\value{
The survey object with a validate step recorded (no data
mutation).
}
\description{
Creates a non-mutating step that checks data invariants when
\code{\link{bake_steps}} is called. Each check is a logical expression
evaluated row-wise against the survey data. If any row fails a check,
the pipeline stops (or warns).
}
\details{
\strong{Lazy evaluation (default):} Like all steps, validation checks are
recorded but \strong{not executed} until \code{\link{bake_steps}} is called.
This means \code{step_validate} can reference variables created by
preceding \code{\link{step_compute}} calls.

The validate step does \strong{not} modify the data in any way. It only
inspects the current state of the data.table and raises an error
or warning if any check fails.
}
\examples{
dt <- data.table::data.table(
  id = 1:5, age = c(25, 30, 45, 50, 60),
  income = c(1000, 2000, 3000, 4000, 5000), w = 1
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "test",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)

# Validate that all ages are positive and income is not NA
svy <- svy |>
  step_validate(age > 0, !is.na(income), .min_n = 3) |>
  bake_steps()

}
\seealso{
Other steps: 
\code{\link{bake_steps}()},
\code{\link{get_steps}()},
\code{\link{step_compute}()},
\code{\link{step_filter}()},
\code{\link{step_join}()},
\code{\link{step_recode}()},
\code{\link{step_remove}()},
\code{\link{step_rename}()},
\code{\link{view_graph}()}
}
\concept{steps}
