% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{survey_to_tibble}
\alias{survey_to_tibble}
\title{survey_to_tibble}
\usage{
survey_to_tibble(svy)
}
\arguments{
\item{svy}{Survey object}
}
\value{
A tibble (\link[tibble:tbl_df-class]{tbl_df}) containing the survey data.
}
\description{
Convert survey to tibble
}
\examples{
\dontshow{if (requireNamespace("tibble", quietly = TRUE)) withAutoprint(\{ # examplesIf}
dt <- data.table::data.table(
  id = 1:5, age = c(25, 30, 45, 50, 60),
  w = rep(1, 5)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "ech",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)
tbl <- survey_to_tibble(svy)
class(tbl)
\dontshow{\}) # examplesIf}
}
\seealso{
Other survey-objects: 
\code{\link{Survey}},
\code{\link{cat_design}()},
\code{\link{cat_design_type}()},
\code{\link{get_data}()},
\code{\link{get_metadata}()},
\code{\link{has_design}()},
\code{\link{has_recipes}()},
\code{\link{has_steps}()},
\code{\link{is_baked}()},
\code{\link{set_data}()},
\code{\link{survey_empty}()},
\code{\link{survey_to_data_frame}()},
\code{\link{survey_to_datatable}()}
}
\concept{survey-objects}
\keyword{survey}
