% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{workflow}
\alias{workflow}
\title{Execute estimation workflow for surveys}
\usage{
workflow(svy, ..., estimation_type = "monthly")
}
\arguments{
\item{svy}{A \strong{list} of Survey objects, or a PoolSurvey.
Even for a single survey, wrap it in \code{list()}:
\code{workflow(svy = list(my_survey), ...)}.
Must contain properly configured sample design.}

\item{...}{Calls to survey package functions (such as \code{svymean},
\code{svytotal}, \code{svyratio}, etc.) that will be executed sequentially}

\item{estimation_type}{Type of estimation (default \code{"monthly"}) that
determines which weight to use. Options:
\code{"monthly"}, \code{"quarterly"}, \code{"annual"}, or vector
with multiple types}
}
\value{
\code{data.table} with results from all
estimations, including columns:
\itemize{
\item \code{stat}: Name of estimated statistic
\item \code{value}: Estimation value
\item \code{se}: Standard error
\item \code{cv}: Coefficient of variation
\item \code{estimation_type}: Type of estimation used
\item \code{survey_edition}: Survey edition
\item Other columns depending on estimation type
}
}
\description{
This function executes a sequence of statistical estimations on Survey
objects, applying functions from the R survey package with appropriate
metadata. Automatically handles different survey types and periodicities.
}
\details{
The function automatically selects the appropriate sample design according
to the specified \code{estimation_type}. For each Survey in the input list,
it executes all functions specified in \code{...} and combines the results.

Supported estimation types:
\itemize{
\item "monthly": Monthly estimations
\item "quarterly": Quarterly estimations
\item "annual": Annual estimations
}

For PoolSurvey objects, it uses a specialized methodology that handles
pooling of multiple surveys.
}
\examples{
# Simple estimation with a test survey
dt <- data.table::data.table(
  x = rnorm(100), g = sample(c("a", "b"), 100, TRUE),
  w = rep(1, 100)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "test",
  psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w")
)
result <- workflow(
  svy = list(svy),
  survey::svymean(~x, na.rm = TRUE),
  estimation_type = "annual"
)

\donttest{
# ECH example with domain estimations
# result <- workflow(
#   survey = list(ech_2023),
#   svyby(~unemployed, ~region, svymean, na.rm = TRUE),
#   estimation_type = "annual")
}

}
\seealso{
\code{\link[survey]{svymean}} for population means
\code{\link[survey]{svytotal}} for population totals
\code{\link[survey]{svyratio}} for ratios
\code{\link[survey]{svyby}} for domain estimations
\code{\link{PoolSurvey}} for survey pooling

Other workflows: 
\code{\link{RecipeWorkflow-class}},
\code{\link{evaluate_cv}()},
\code{\link{print.RecipeWorkflow}()},
\code{\link{publish_workflow}()},
\code{\link{read_workflow}()},
\code{\link{reproduce_workflow}()},
\code{\link{save_workflow}()},
\code{\link{workflow_from_list}()},
\code{\link{workflow_table}()}
}
\concept{workflows}
\keyword{survey}
