% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_table.R
\name{workflow_table}
\alias{workflow_table}
\title{Create publication-quality table from workflow results}
\usage{
workflow_table(
  result,
  ci = 0.95,
  digits = 2,
  compare_by = NULL,
  show_cv = TRUE,
  show_se = TRUE,
  title = NULL,
  subtitle = NULL,
  source_note = TRUE,
  locale = "en",
  theme = "publication"
)
}
\arguments{
\item{result}{A \code{data.table} from \code{\link[=workflow]{workflow()}}.}

\item{ci}{Confidence level for intervals (default 0.95).
Set to \code{NULL} to hide confidence intervals.}

\item{digits}{Number of decimal places (default 2).}

\item{compare_by}{Column name to pivot for side-by-side comparison
(e.g., \code{"survey_edition"}).}

\item{show_cv}{Logical; show CV column with quality classification.}

\item{show_se}{Logical; show SE column.}

\item{title}{Table title. Auto-generated if \code{NULL}.}

\item{subtitle}{Table subtitle. Auto-generated if \code{NULL}.}

\item{source_note}{Logical; show provenance footer.}

\item{locale}{Locale for number formatting (\code{"en"} or \code{"es"}).}

\item{theme}{Table theme: \code{"publication"} (clean) or \code{"minimal"}.}
}
\value{
A \code{gt_tbl} object. Export via \code{gt::gtsave()} to .html, .docx,
.pdf, .png, or .rtx. Falls back to \code{\link[knitr:kable]{knitr::kable()}} if gt is not
installed.
}
\description{
Formats a \code{\link[=workflow]{workflow()}} result as a gt table with confidence intervals,
CV quality classification, and provenance-based source notes.
}
\details{
CV quality classification follows INE/CEPAL standards:
\itemize{
\item Excellent: CV < 5\\%
\item Very good: 5-10\\%
\item Good: 10-15\\%
\item Acceptable: 15-25\\%
\item Use with caution: 25-35\\%
\item Do not publish: >= 35\\%
}
}
\examples{
svy <- Survey$new(
  data = data.table::data.table(
    x = rnorm(100), g = sample(c("a", "b"), 100, TRUE), w = rep(1, 100)
  ),
  edition = "2023", type = "test", psu = NULL,
  engine = "data.table", weight = add_weight(annual = "w")
)
result <- workflow(
  list(svy), survey::svymean(~x, na.rm = TRUE),
  estimation_type = "annual"
)
\donttest{
if (requireNamespace("gt", quietly = TRUE)) {
  workflow_table(result)
}
}

}
\seealso{
Other workflows: 
\code{\link{RecipeWorkflow-class}},
\code{\link{evaluate_cv}()},
\code{\link{print.RecipeWorkflow}()},
\code{\link{publish_workflow}()},
\code{\link{read_workflow}()},
\code{\link{reproduce_workflow}()},
\code{\link{save_workflow}()},
\code{\link{workflow}()},
\code{\link{workflow_from_list}()}
}
\concept{workflows}
