% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhp.R
\name{get_gcv}
\alias{get_gcv}
\title{Extract GCV Value}
\usage{
get_gcv(x)
}
\arguments{
\item{x}{Result from \code{\link{mhp_filter}} (either data.table or mhp object).}
}
\value{
Numeric. The GCV value at the optimal lambda.
}
\description{
Extract the generalized cross-validation (GCV) value from Modified HP filter results.
}
\examples{
set.seed(123)
result <- mhp_filter(cumsum(rnorm(100)), max_lambda = 10000)
get_gcv(result)

# With mhp object
result_obj <- mhp_filter(cumsum(rnorm(100)), max_lambda = 10000, as_dt = FALSE)
get_gcv(result_obj)

}
