% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-root.R
\name{gdb.create_linked}
\alias{gdb.create_linked}
\title{Create a linked database with symlinks to a parent database}
\usage{
gdb.create_linked(path, parent)
}
\arguments{
\item{path}{Path for the new linked database}

\item{parent}{Path to the parent database (with seq and chrom_sizes.txt)}
}
\value{
Invisible TRUE on success
}
\description{
Creates a new database directory structure with symbolic links to the
parent database's seq/ directory and chrom_sizes.txt file.
}
\details{
This is useful for creating a writable database that shares sequence
data with a read-only main database. The new database can be set as the
working database via \code{gsetroot()}, and then the parent database
can be loaded as a dataset via \code{gdataset.load()}.
}
\examples{
\dontrun{
# Create linked database sharing sequence data with main database
gdb.create_linked("~/my_tracks", parent = "/shared/genomics/hg38")

# Set linked database as working database and load parent as dataset
gsetroot("~/my_tracks")
gdataset.load("/shared/genomics/hg38")
}

}
\seealso{
\code{\link{gsetroot}}, \code{\link{gdb.create}},
  \code{\link{gdataset.load}}, \code{\link{gdataset.ls}}
}
\keyword{~create}
\keyword{~database}
\keyword{~db}
