% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_combine.R
\name{lr_combine}
\alias{lr_combine}
\title{Combine Likelihood Ratios from Multiple Sources}
\usage{
lr_combine(LRdatasim1, LRdatasim2)
}
\arguments{
\item{LRdatasim1}{A data.frame with columns \code{Unrelated} and
\code{Related} containing LR values from the first evidence source.
Must be a data.frame (use \code{\link{lr_to_dataframe}} to convert
genetic simulation output first).}

\item{LRdatasim2}{A data.frame with columns \code{Unrelated} and
\code{Related} containing LR values from the second evidence source.}
}
\value{
A data.frame with columns:
\itemize{
\item \code{Unrelated}: Product of LR values under H2
\item \code{Related}: Product of LR values under H1
}
The number of rows equals the minimum of the input data frames.
}
\description{
Combines (multiplies) likelihood ratios from two independent evidence
sources using the Bayesian multiplication principle. This is used to
integrate genetic and non-genetic evidence, or multiple non-genetic
variables.
}
\details{
Under the assumption of conditional independence of evidence given
each hypothesis, the combined LR is the product of individual LRs:
\deqn{LR_{combined} = LR_1 \times LR_2}

This follows from Bayes' theorem and is valid when the evidence sources
are conditionally independent given the hypothesis.

\strong{Important:} Both inputs must be data.frames with the same
structure. If using output from \code{\link{sim_lr_genetic}}, first
convert it using \code{\link{lr_to_dataframe}}.
}
\examples{
# Simulate LRs from two different variables
lr_sex <- sim_lr_prelim("sex", numsims = 500, seed = 123)
lr_age <- sim_lr_prelim("age", numsims = 500, seed = 456)

# Combine the evidence
lr_combined <- lr_combine(lr_sex, lr_age)
head(lr_combined)

# Compare distributions
summary(log10(lr_sex$Related))
summary(log10(lr_combined$Related))

# Visualize combined distribution
plot_lr_distribution(lr_combined)

# Combining genetic and non-genetic evidence
library(forrel)
x <- linearPed(2)
x <- setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x <- profileSim(x, N = 1, ids = 2)

# Simulate genetic LRs and convert to dataframe
lr_genetic <- sim_lr_genetic(x, missing = 5, numsims = 100, seed = 123)
lr_genetic_df <- lr_to_dataframe(lr_genetic)

# Simulate non-genetic LRs
lr_prelim <- sim_lr_prelim("sex", numsims = 100, seed = 123)

# Combine both sources
lr_total <- lr_combine(lr_genetic_df, lr_prelim)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{sim_lr_genetic}} for genetic LR simulations,
\code{\link{sim_lr_prelim}} for non-genetic LR simulations,
\code{\link{lr_to_dataframe}} for converting genetic simulations,
\code{\link{plot_lr_distribution}} for visualizing combined distributions.
}
