% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproducibility.R
\name{mp_bundle_results}
\alias{mp_bundle_results}
\title{Bundle results with manifest and optional labels}
\usage{
mp_bundle_results(
  result,
  manifest,
  study_id = NULL,
  analyst = NULL,
  notes = NULL
)
}
\arguments{
\item{result}{An object of class \code{mp_power}, \code{mp_sensitivity}, or \code{mp_power_curve}.}

\item{manifest}{An \code{mp_manifest} object (from \code{\link[=mp_manifest]{mp_manifest()}}).}

\item{study_id}{Optional character; study or run identifier.}

\item{analyst}{Optional character; analyst name or ID.}

\item{notes}{Optional character; free-form notes.}
}
\value{
An object of class \code{mp_bundle} with components \code{result}, \code{manifest},
and \code{labels} (list with \code{study_id}, \code{analyst}, \code{notes}).
}
\description{
Combines a single result object (\link{mp_power}, \link{mp_sensitivity}, or
\link{mp_power_curve}), a reproducibility manifest, and optional user labels
into one object. Diagnostics and result structure are retained unchanged.
}
