% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapperfunctions.R
\name{geweke.diagTAR}
\alias{geweke.diagTAR}
\title{Geweke's convergence diagnostic for \code{mtar} objects}
\usage{
geweke.diagTAR(x, frac1 = 0.1, frac2 = 0.5)
}
\arguments{
\item{x}{An object of class \code{mtar} returned by the function \code{mtar()}.}

\item{frac1}{A numeric value in \eqn{(0,1)} specifying the fraction of the initial part
of each chain to be used in the diagnostic.}

\item{frac2}{A numeric value in \eqn{(0,1)} specifying the fraction of the final part
of each chain to be used in the diagnostic.}
}
\value{
A list containing the Geweke z-scores for the parameters of the \code{mtar} model.
}
\description{
This function computes Geweke's convergence diagnostic for Markov chain Monte Carlo
(MCMC) output obtained from Bayesian estimation of multivariate TAR models. It is a
wrapper around \code{geweke.diag()} that applies the diagnostic to the posterior chains
returned by a call to \code{mtar()}.
}
\seealso{
\code{\link[coda]{geweke.diag}}
}
