% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determine_weights.R
\name{determine_weights_using_neg_log_loss}
\alias{determine_weights_using_neg_log_loss}
\title{Determine Weights for Density Estimators for SuperLearner}
\usage{
determine_weights_using_neg_log_loss(data, y_variable, obs_weights = NULL)
}
\arguments{
\item{data}{A data.frame with columns corresponding to predicted densities from each learner and the true y_variable from held-out data}

\item{y_variable}{A character indicating the outcome variable in the data.frame.}

\item{obs_weights}{A vector of weights for each observation that dictate
how prediction should be more targeted to higher weighted observations.}
}
\value{
A vector of weights to be used for each of the learners.
}
\description{
Determine Weights for Density Estimators for SuperLearner
}
\examples{
predicted_densities <- data.frame(
  lm = lnr_lm_density(mtcars, mpg ~ hp)(mtcars),
  earth = lnr_homoskedastic_density(mtcars, mpg ~ hp, mean_lnr = lnr_earth)(mtcars),
  rf = lnr_homoskedastic_density(mtcars, mpg ~ hp, mean_lnr = lnr_rf)(mtcars),
  rf2 = lnr_homoskedastic_density(mtcars, mpg ~ hp, mean_lnr = lnr_rf,
    mean_lnr_args = list(ntree = 20))(mtcars),
  mpg = mtcars$mpg)
determine_weights_using_neg_log_loss(predicted_densities, y_variable = 'mpg')
}
