% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetQuery.R
\name{datasetQuery}
\alias{datasetQuery}
\title{Query the query endpoint of the NEON API and create an arrow dataset from the results}
\usage{
datasetQuery(
  dpID,
  site = "all",
  startdate = NA,
  enddate = NA,
  tabl = NA_character_,
  hor = NA,
  ver = NA,
  package = "basic",
  release = "current",
  include.provisional = FALSE,
  token = NA_character_
)
}
\arguments{
\item{dpID}{The identifier of the NEON data product to pull, in the form DPL.PRNUM.REV, e.g. DP1.10023.001}

\item{site}{Either the string 'all', meaning all available sites, or a character vector of 4-letter NEON site codes, e.g. c('ONAQ','RMNP'). Defaults to all.}

\item{startdate}{Either NA, meaning all available dates, or a character vector in the form YYYY-MM, e.g. 2017-01. Defaults to NA.}

\item{enddate}{Either NA, meaning all available dates, or a character vector in the form YYYY-MM, e.g. 2017-01. Defaults to NA.}

\item{tabl}{The name of a single data table to download.}

\item{hor}{The horizontal index of data to download. Only applicable to sensor (IS) data.}

\item{ver}{The vertical index of data to download. Only applicable to sensor (IS) data.}

\item{package}{Either 'basic' or 'expanded', indicating which data package to download. Defaults to basic.}

\item{release}{The data release to be downloaded; either 'current' or the name of a release, e.g. 'RELEASE-2021'. 'current' returns the most recent release, as well as provisional data if include.provisional is set to TRUE. To download only provisional data, use release='PROVISIONAL'. Defaults to 'current'.}

\item{include.provisional}{T or F, should provisional data be included in downloaded files? Defaults to F. See https://www.neonscience.org/data-samples/data-management/data-revisions-releases for details on the difference between provisional and released data.}

\item{token}{User specific API token (generated within data.neonscience.org user accounts). Optional.}
}
\value{
An arrow dataset for the data requested.
}
\description{
Uses the query endpoint of the NEON API to find the full list of files for a given data product, release, site(s), and date range, then turns them into an arrow dataset.
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
}
