% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alerts.R
\name{alert}
\alias{alert}
\title{Create an alert}
\usage{
alert(
  ...,
  type = c("default", "standard"),
  close = FALSE,
  color = c("none", "primary", "secondary", "info", "success", "danger", "warning"),
  outline = FALSE,
  icon = NULL
)
}
\arguments{
\item{...}{Content of the alert}

\item{type}{Choose a style for the alert, choices include "default", "standard"}

\item{close}{Allow alert to be closable, TRUE or FALSE}

\item{color}{Color of the alert, choose between "none", "primary", "secondary", "info", "success", "danger", "warning"}

\item{outline}{Include an outline and exclude background, TRUE or FALSE}

\item{icon}{Include an icon to the left of the content}
}
\value{
HTML of an alert box to be inserted within a page
}
\description{
Create an alert with various styles
}
\examples{
if (interactive()) {
card(
  header = FALSE,
  shiny::h2("Standard alert (closeable)"),
  alert("EX1", type = "standard",
  color = "primary"),
  alert("EX2", type = "standard",
  color = "secondary"),
  alert("EX3", type = "standard",
  color = "secondary", outline = TRUE),
  alert("EX4", type = "standard",
  color = "danger", outline = TRUE, close = TRUE),
  alert("EX5", type = "standard",
  close = TRUE),
  alert("EX6", type = "standard",
  color = "primary", icon = shiny::icon("info"))
)
}

}
