% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.r
\name{getters}
\alias{getters}
\alias{ng_order}
\alias{ng_order,ngram-method}
\alias{get.ngrams}
\alias{get.ngrams,ngram-method}
\alias{get.string}
\alias{get.string,ngram-method}
\alias{get.nextwords}
\alias{get.nextwords,ngram-method}
\title{ngram Getters}
\usage{
ng_order(ng, decreasing = FALSE)

\S4method{ng_order}{ngram}(ng, decreasing = FALSE)

get.ngrams(ng)

\S4method{get.ngrams}{ngram}(ng)

get.string(ng)

\S4method{get.string}{ngram}(ng)

get.nextwords(ng)

\S4method{get.nextwords}{ngram}(ng)
}
\arguments{
\item{ng}{An ngram object.}

\item{decreasing}{Should the sorted order be in descending order?}
}
\description{
Some simple "getters" for \code{ngram} objects. Necessary since the internal
representation is not a native R object.
}
\details{
\code{ngram.order} returns an R vector with the original corpus order of the ngrams.

\code{get.ngrams()} returns an R vector of all n-grams.

\code{get.nextwords()} does nothing at the moment; it will be implemented in
future releases.

\code{getnstring()} recovers the input string as an R string.
}
\examples{
library(ngram)

str = "A B A C A B B"
ng = ngram(str)
get.ngrams(ng)[ng_order(ng)]

}
\seealso{
\code{\link{ngram-class}}, \code{\link{ngram}}
}
\keyword{Tokenization}
