% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Misc.R
\name{findSIMQuantile}
\alias{findSIMQuantile}
\title{Find quantiles of the simulated data.}
\usage{
findSIMQuantile(sim_data,
               X,
               X_bin,
               probs = c(0.1,0.5,0.9),
               conf.level = 0.95,
               approx = FALSE, ...)
}
\arguments{
\item{sim_data}{A matrix of simulated data with only Y values collected.}

\item{X}{A numeric vector corresponding to Y.}

\item{X_bin}{Binning result from makeCOVbin function.}

\item{probs}{A numeric vector of probabilities.}

\item{conf.level}{Confidence level of the interval.}

\item{approx}{Arguments to be passed to methods}

\item{...}{Arguments to be passed to methods}
}
\value{
quantiles of sim_data using X_bin
}
\description{
Find quantiles of the simulated data.
}
\examples{
data(origdata)
data(simdata)
CUT = FindBestCut(origdata$TIME,8)$cutoffs
time_bin = makeCOVbin(origdata$TIME,K=8,cutoffs = CUT)
findSIMQuantile(simdata,origdata$TIME,X_bin=time_bin)
}
