% Generated by hand for npRmpi helper functions
\name{npRmpi.start}
\alias{npRmpi.start}
\alias{npRmpi.stop}
\alias{npRmpi.session.info}
\title{Start/Stop Helpers for Interactive npRmpi Sessions}
\description{
Convenience helpers for interactive use of \pkg{npRmpi}. These functions
provide a recommended, robust workflow: initialize a slave pool once and
reuse it across multiple examples within the same R session.
}
\usage{
npRmpi.start(..., nslaves = 1, comm = 1)

npRmpi.stop(force = FALSE, dellog = TRUE, comm = 1)

npRmpi.session.info(comm = 1)
}
\arguments{
  \item{\dots}{Additional arguments passed to \code{mpi.spawn.Rslaves()}.}
  \item{nslaves}{Number of slaves to spawn for interactive execution.}
  \item{comm}{Communicator used for the master+slaves pool (defaults to \code{1}).}
  \item{force}{Logical; when \code{TRUE}, force a hard shutdown of slave daemons.}
  \item{dellog}{Logical; when \code{TRUE}, remove slave log files (if applicable).}
}
\details{
\code{npRmpi.start()} ensures that a slave pool exists (spawning if needed)
and runs \code{np.mpi.initialize()} on all ranks via \code{mpi.bcast.cmd()}.

\code{npRmpi.stop()} is idempotent: if no slaves are running it returns
silently. When \code{options(npRmpi.reuse.slaves=TRUE)} (default on some
systems), \code{force=FALSE} performs a soft-close to keep daemons alive
for reuse within the session; use \code{force=TRUE} to actually shut down
the slaves.

\code{npRmpi.session.info()} prints and returns a list of useful version,
platform, and MPI/communicator details to aid reproducibility and bug
reports.
}
\examples{
\dontrun{
## Not run in checks: excluded to keep MPI examples stable and check times short.
## Start once, run many examples, then stop.
npRmpi.start(nslaves=1)

## ... run np* calls here ...

## Soft-stop (may keep daemons alive for reuse)
npRmpi.stop()

## Hard-stop (actually shuts down slaves)
## npRmpi.stop(force=TRUE)
}
}
\keyword{nonparametric}

