% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratify.R
\name{stratify}
\alias{stratify}
\title{Bin quantitative data into strata}
\usage{
stratify(
  x,
  breaks = NULL,
  n_strata = 5,
  transform = identity,
  offset = 0,
  zero_stratum = FALSE
)
}
\arguments{
\item{x}{A matrix or vector containing non-negative values.}

\item{breaks}{Numeric vector of stratum breakpoints.}

\item{n_strata}{Integer giving the number of strata to split the
data into. Must be 2 or greater. Larger values yield randomizations
with less mixing but higher fidelity to the original marginal
distributions. Default is \code{5}. Ignored unless \code{breaks = NULL}.}

\item{transform}{A function used to transform the values in
\code{x} before assigning them to \code{n_strata} equal-width
intervals. Examples include \code{sqrt}, \code{log},
\code{rank} (for equal-occupancy strata), etc.;
the default is \code{identity}. If \code{zero_stratum = TRUE}, the
transformation is only applied on nonzero values. The function should
pass NA values. This argument is ignored unless \code{breaks = NULL}.}

\item{offset}{Numeric value between -1 and 1 (default 0) indicating
how much to shift stratum breakpoints relative to the binwidth (applied
during quantization as: \code{breaks <- breaks + offset * bw}). To
assess sensitivity to stratum boundaries, run \code{quantize()} multiple
times with different offset values. Ignored unless \code{breaks = NULL}.}

\item{zero_stratum}{Logical indicating whether to segregate zeros into their
own stratum. If \code{FALSE} (the default), zeros will likely be combined
into a stratum that also includes small positive numbers. If \code{breaks} is
specified, zero simply gets added as an additional break; if not, one
of the \code{n_strata} will represent zeros and the others will be nonzero ranges.}
}
\value{
An object the same size as x, with integer values representing
stratum classifications.
}
\description{
Bin quantitative data into strata
}
\examples{
# Stratify a numeric vector
x <- c(0, 0, 0.1, 0.5, 1.2, 3.4, 5.6, 10.2)
stratify(x, n_strata = 3)

# With transformation
stratify(x, n_strata = 3, transform = log1p)

# Separate zero stratum
stratify(x, n_strata = 3, zero_stratum = TRUE)

}
