% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_independent_alleles.R
\name{pr_independent_alleles}
\alias{pr_independent_alleles}
\title{Compute the probability distribution of the number of independent alleles in a mixture with dropout}
\usage{
pr_independent_alleles(dropout_prs)
}
\arguments{
\item{dropout_prs}{Numeric vector. Dropout probabilities per contributor.}
}
\value{
A named numeric vector describing the probability distribution. Numeric values are the probabilities corresponding to the names describing integer values.
}
\description{
Without dropout, each mixture contributor has two \emph{independent} but not necessarily \emph{distinct} alleles that are represented in the DNA mixture. If the probability of dropout for a mixture contributor is greater than zero, then the mixture contributor has either 0 (full dropout), 1 (partial dropout) or 2 (no dropout) independent alleles that are represented in the mixture. This function computes the probability distribution of the number of independent alleles that unrelated mixture contributors have in total for a locus given their dropout parameters.
}
\examples{
# a dropout pr. of 0.5
p <- pr_independent_alleles(0.5)
stopifnot(all.equal(as.vector(p),
                    c(0.5^2, 2 * 0.5 * 0.5, (1-0.5)^2)))

# one contrib. without dropout and one with d=0.5
p1 <- pr_independent_alleles(c(0, 0.5))
stopifnot(identical(as.integer(names(p1)),
                    as.integer(names(p)) + 2L))
}
\seealso{
\link{pr_independent_alleles_ped}
}
