% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_tlc_new_driver_app_status.R
\name{nyc_tlc_new_driver_app_status}
\alias{nyc_tlc_new_driver_app_status}
\title{NYC TLC New Driver Application Status}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/dpec-ucu7>
}
\usage{
nyc_tlc_new_driver_app_status(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing TLC New Driver Application Status data.
}
\description{
Downloads TLC New Driver Application Status data from NYC Open Data.
}
\details{
This dataset provides the application status for individuals applying
for a New York City Taxi and Limousine Commission (TLC) driver's license.
It includes details such as application date, drug test status,
defensive driving completion, and final approval outcome.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_tlc_new_driver_app_status(limit = 10)
head(small_sample)

\donttest{
nyc_tlc_new_driver_app_status(limit = 5000)
nyc_tlc_new_driver_app_status(filters = list(drug_test = "NEEDED"))
}
}
