% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockObservation.R
\name{mockObservation}
\alias{mockObservation}
\title{Generates a mock observation table and integrates it into an existing CDM object.}
\usage{
mockObservation(cdm, recordPerson = 1, seed = NULL)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object that must already include 'person', 'observation_period', and 'concept' tables.
This object serves as the base CDM structure where the observation data will be added.
The 'person' and 'observation_period' tables must be populated as they are necessary for generating accurate observation records.}

\item{recordPerson}{An integer specifying the expected number of observation records to generate per person.
This parameter allows for the simulation of varying frequencies of healthcare observations among individuals in the cohort,
reflecting real-world variability in patient monitoring and health assessments.}

\item{seed}{An optional integer used to set the seed for random number generation, ensuring reproducibility of the generated data.
If provided, this seed enables the function to produce consistent results each time it is run with the same inputs.
If 'NULL', the seed is not set, which can lead to different outputs on each run.}
}
\value{
Returns the modified \code{cdm} object with the new 'observation' table added. This table includes the simulated
observation data for each person, ensuring that each record is correctly linked to individuals in the 'person' table
and falls within valid observation periods.
}
\description{
This function simulates observation records for individuals within a specified cohort. It creates a realistic dataset by generating observation records based on the specified number of records per person. Each observation record is correctly associated with an individual within valid observation periods, ensuring the integrity of the data.
}
\examples{
library(omock)

# Create a mock CDM reference and add observation records
cdm <- mockCdmReference() |>
  mockPerson() |>
  mockObservationPeriod() |>
  mockObservation(recordPerson = 3)

# View the generated observation data
print(cdm$observation)
}
