% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse.R
\name{inverse}
\alias{inverse}
\alias{inverse.name}
\alias{inverse.function}
\title{Invert an R operator}
\usage{
inverse(x, ...)
}
\arguments{
\item{x}{object representing an R operator}

\item{...}{additional arguments}
}
\value{
\code{inverse} returns the inverse in the same form as the \code{x}
  argument. Thus, if a name is provided, a name is returned. If a function is
  provided, a function is returned.
}
\description{
\code{inverse} is a S3 generic method for inverting an R operator in the
mathematical sense. Presently, inverses are defined for relational
operators, i.e. changing \code{>} to \code{<=} etc.
}
\details{
Arguments will be checked against the defined list of inverses,
If an entry exists, the corresponding inverse is returned.
}
\examples{
  \dontrun{
    inverse( as.name( '!=' ) )
    inverse( `==` )
 } 
}
\references{
http://en.wikipedia.org/wiki/Inverse_mathematics.
}
\seealso{
\code{\link{operators}} especially \code{operators(type="relational"))}
}
\author{
Christopher Brown
}
\keyword{methods}
\keyword{symbolmath}
\keyword{utilities}
