% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optweightMV.R
\name{optweightMV}
\alias{optweightMV}
\alias{optweightMV.fit}
\title{Stable Balancing Weights for Multivariate Treatments}
\usage{
optweightMV(
  formula.list,
  data = NULL,
  tols.list = list(0),
  estimand = "ATE",
  targets = NULL,
  target.tols.list = list(0),
  s.weights = NULL,
  b.weights = NULL,
  norm = "l2",
  min.w = 1e-08,
  verbose = FALSE,
  ...
)

optweightMV.fit(
  covs.list,
  treat.list,
  tols.list = list(0),
  estimand = "ATE",
  targets = NULL,
  target.tols.list = list(0),
  s.weights = NULL,
  b.weights = NULL,
  norm = "l2",
  std.binary = FALSE,
  std.cont = TRUE,
  min.w = 1e-08,
  verbose = FALSE,
  solver = NULL,
  ...
)
}
\arguments{
\item{formula.list}{a list of formulas, each with a treatment variable on the left hand side and the covariates to be balanced on the right hand side.}

\item{data}{an optional data set in the form of a data frame that contains the variables in \code{formula.list}.}

\item{tols.list}{a list of vectors of balance tolerance values for each covariate for each treatment. The resulting weighted balance statistics will be at least as small as these values. If only one value is supplied, it will be applied to all covariates. See Details. Default is 0 for all covariates.}

\item{estimand}{the desired estimand, which determines the target population. Only "ATE" or \code{NULL} are supported. \code{estimand} is ignored when \code{targets} is non-\code{NULL}. If both \code{estimand} and \code{targets} are \code{NULL}, no targeting will take place.}

\item{targets}{an optional vector of target population mean values for each covariate. The resulting weights ensure the midpoint between group means are within \code{target.tols} units of the target values for each covariate. If \code{NULL} or all \code{NA}, \code{estimand} will be used to determine targets. Otherwise, \code{estimand} is ignored. If any target values are \code{NA}, the corresponding variable will not be targeted and its weighted mean will be wherever the weights yield the smallest value of the objective function; this is only allowed if all treatments are binary or multi-category. Can also be the output of a call to \code{\link[=process_targets]{process_targets()}}. See Details.}

\item{target.tols.list}{a list of vectors of target balance tolerance values for each covariate for each treatment. For binary and multi-category treatments, the average of each pair of means will be at most as far from the target means as these values. Can also be the output of a call to \code{\link[=process_tols]{process_tols()}}. See Details. Default is 0 for all covariates. Ignored with continuous treatments.}

\item{s.weights}{a vector of sampling weights. For \code{optweightMV()}, can also be the name of a variable in \code{data} that contains sampling weights.}

\item{b.weights}{a vector of base weights. If supplied, the desired norm of the distance between the estimated weights and the base weights is minimized. For \code{optweightMV()}, can also the name of a variable in \code{data} that contains base weights.}

\item{norm}{\code{character}; a string containing the name of the norm corresponding to the objective function to minimize. Allowable options include \code{"l1"} for the \eqn{L_1} norm, \code{"l2"} for the \eqn{L_2} norm (the default), \code{"linf"} for the \eqn{L_\infty} norm, \code{"entropy"} for the relative entropy, and \code{"log"} for the sum of the negative logs. See Details.}

\item{min.w}{\code{numeric}; a single value less than 1 for the smallest allowable weight. Some analyses require nonzero weights for all units, so a small, nonzero minimum may be desirable. The default is \code{1e-8} (\eqn{10^{-8}}), which does not materially change the properties of the weights from a minimum of 0 but prevents warnings in some packages that use weights in model fitting. When \code{norm} is \code{"entropy"} or \code{"log"} and \code{min.w <= 0}, \code{min.w} will be set to the smallest nonzero value.}

\item{verbose}{\code{logical}; whether information on the optimization problem solution should be printed. Default is \code{FALSE}.}

\item{\dots}{for \code{optweightMV()}, additional arguments passed to \code{optweightMV.fit()}, including options that are passed to the settings function corresponding to \code{solver}.}

\item{covs.list}{a list containing one numeric matrix of covariates to be balanced for each treatment.}

\item{treat.list}{a list containing one vector of treatment statuses for each treatment.}

\item{std.binary, std.cont}{\code{logical}; whether the tolerances are in standardized mean units (\code{TRUE}) or raw units (\code{FALSE}) for binary variables and continuous variables, respectively. The default is \code{FALSE} for \code{std.binary} because raw proportion differences make more sense than standardized mean difference for binary variables. These arguments are analogous to the \code{binary} and \code{continuous} arguments in \pkgfun{cobalt}{bal.tab}.}

\item{solver}{string; the name of the optimization solver to use. Allowable options depend on \code{norm}. Default is to use whichever eligible solver is installed, if any, or the default solver for the corresponding \code{norm}. See Details for information.}
}
\value{
For \code{optweightMV()}, an \code{optweightMV} object with the following elements:
\item{weights}{The estimated weights, one for each unit.}
\item{treat.list}{A list of the values of the treatment variables.}
\item{covs.list}{A list of the covariates for each treatment used in the fitting. Only includes the raw covariates, which may have been altered in the fitting process.}
\item{s.weights}{The provided sampling weights.}
\item{b.weights}{The provided base weights.}
\item{call}{The function call.}
\item{tols}{A list of tolerance values for each covariate for each treatment.}
\item{duals}{A list of data.frames containing the dual variables for each covariate for each treatment. See \code{\link[=optweight]{optweight()}} for interpretation of these values.}
\item{info}{A list containing information about the performance of the optimization at termination.}
\item{norm}{The \code{norm} used.}
\item{solver}{The \code{solver} used.}

For \code{optweightMV.fit()}, an \code{optweightMV.fit} object with the following elements:
\item{w}{The estimated weights, one for each unit.}
\item{duals}{A data.frame containing the dual variables for each covariate.}
\item{info}{A list containing information about the performance of the optimization at termination.}
\item{norm}{The \code{norm} used.}
\item{solver}{The \code{solver} used.}
}
\description{
Estimates stable balancing weights for the supplied multivariate (i.e., multiple) treatments and covariates. The degree of balance for each covariate is specified by \code{tols.list}. See Zubizarreta (2015) and Wang & Zubizarreta (2020) for details of the properties of the weights and the methods used to fit them.
}
\details{
\code{optweightMV()} is the primary user-facing function for estimating stable balancing weights for multivariate treatments. The optimization is performed by the lower-level function \code{optweightMV.fit()}, which transforms the inputs into the required inputs for the optimization functions and then supplies the outputs (the weights, dual variables, and convergence information) back to \code{optweightMV()}. Little processing of inputs is performed by \code{optweightMV.fit()}, as this is normally handled by \code{optweightMV()}.

See \code{\link[=optweight]{optweight()}} for more information about balance tolerances (i.e., those specified in \code{tols.list}), \code{targets}, \code{norm}, \code{solver}, and convergence failure.
}
\examples{
\dontshow{if (rlang::is_installed("cobalt")) withAutoprint(\{ # examplesIf}
library("cobalt")
data("lalonde", package = "cobalt")

# Balancing two treatments
(ow1 <- optweightMV(list(treat ~ age + educ + race + re74,
                         re75 ~ age + educ + race + re74),
                    data = lalonde))

summary(ow1)

bal.tab(ow1)
\dontshow{\}) # examplesIf}
}
\references{
Chattopadhyay, A., Cohn, E. R., & Zubizarreta, J. R. (2024). One-Step Weighting to Generalize and Transport Treatment Effect Estimates to a Target Population. \emph{The American Statistician}, 78(3), 280–289. \doi{10.1080/00031305.2023.2267598}

Källberg, D., & Waernbaum, I. (2023). Large Sample Properties of Entropy Balancing Estimators of Average Causal Effects. \emph{Econometrics and Statistics}. \doi{10.1016/j.ecosta.2023.11.004}

Wang, Y., & Zubizarreta, J. R. (2020). Minimal dispersion approximately balancing weights: Asymptotic properties and practical considerations. \emph{Biometrika}, 107(1), 93–105. \doi{10.1093/biomet/asz050}

Zubizarreta, J. R. (2015). Stable Weights that Balance Covariates for Estimation With Incomplete Outcome Data. \emph{Journal of the American Statistical Association}, 110(511), 910–922. \doi{10.1080/01621459.2015.1023805}
}
\seealso{
\code{\link[=optweight]{optweight()}} for more information on the optimization, specifications, and options.
}
