% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{orcid}
\alias{orcid}
\title{Search ORCID registry}
\usage{
orcid(query = NULL, rows = 10, start = 0, token = NULL, ...)
}
\arguments{
\item{query}{Character string. Solr query string (e.g., "keyword:ecology",
"family-name:Smith AND given-names:John"). If NULL, returns empty results.}

\item{rows}{Integer. Number of results to return (default: 10, max: 1000).}

\item{start}{Integer. Starting position for pagination (default: 0).}

\item{token}{Character string or NULL. Optional API token. Most searches
work without authentication.}

\item{...}{Additional parameters passed to the API request.}
}
\value{
A data.table with columns:
\describe{
\item{orcid_id}{ORCID identifier}
\item{given_names}{Given name(s)}
\item{family_name}{Family name}
\item{credit_name}{Credit/published name}
\item{other_names}{Alternative names (list column)}
}
Returns empty data.table if no results found.
The total number of matches is available as \code{attr(result, "found")}.
}
\description{
Search for ORCID profiles using Apache Solr query syntax. This function
provides direct access to the ORCID search API with full query capabilities.
}
\details{
This function queries the ORCID search endpoint:
\code{https://pub.orcid.org/v3.0/expanded-search}

The expanded-search endpoint returns name information along with ORCID IDs,
unlike the basic search endpoint which only returns identifiers.

\strong{Query Field Examples:}
\itemize{
\item \code{family-name:Smith}
\item \code{given-names:John}
\item \code{keyword:ecology}
\item \code{affiliation-org-name:Harvard}
\item \code{digital-object-ids:10.1371/*}
\item \code{email:*@example.org}
}

\strong{Boolean Operators:}
Use AND, OR, NOT for complex queries:
\code{"family-name:Smith AND affiliation-org-name:Harvard"}
}
\examples{
\dontrun{
# Search by keyword
results <- orcid("keyword:ecology", rows = 20)
print(results)
attr(results, "found")  # Total number of matches

# Search by name
results <- orcid("family-name:Fabbri AND given-names:Lorenzo")

# Search by affiliation
results <- orcid("affiliation-org-name:Stanford")

# Search by DOI
results <- orcid("digital-object-ids:10.1371/*")

# Pagination
page1 <- orcid("keyword:genomics", rows = 10, start = 0)
page2 <- orcid("keyword:genomics", rows = 10, start = 10)
}

}
\references{
ORCID API Search Documentation: \url{https://info.orcid.org/documentation/api-tutorials/api-tutorial-searching-the-orcid-registry/}
}
\seealso{
\code{\link{orcid_search}} for a more user-friendly interface,
\code{\link{orcid_doi}} for DOI-specific searches
}
