% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{orderly_location_fetch_metadata}
\alias{orderly_location_fetch_metadata}
\title{Fetch metadata from a location}
\usage{
orderly_location_fetch_metadata(location = NULL, root = NULL)
}
\arguments{
\item{location}{The name of a location to pull from (see
\code{\link[=orderly_location_list]{orderly_location_list()}} for possible values).  If not
given, pulls from all locations.  The "local" and "orphan"
locations are always up to date and pulling metadata from them
does nothing.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Nothing
}
\description{
Fetch metadata from a location, updating the index.  This should
always be relatively quick as it updates only small files that
contain information about what can be found in remote packets.
}
\examples{
# Two roots, one local and one representing some remote orderly location:
local <- orderly_example()
remote <- orderly_example()

# We create a packet in the remote root:
orderly_run("data", root = remote)

# Add the remote as a path location to the local root:
orderly_location_add_path("remote", remote, root = local)

# Pull metadata from 'remote' into our local version
orderly_location_fetch_metadata(root = local)
}
