% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{orderly_location_rename}
\alias{orderly_location_rename}
\title{Rename a location}
\usage{
orderly_location_rename(old, new, root = NULL)
}
\arguments{
\item{old}{The current short name of the location.
Cannot rename \code{local} or \code{orphan}}

\item{new}{The desired short name of the location.
Cannot be one of \code{local} or \code{orphan}}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Nothing
}
\description{
Rename an existing location
}
\examples{
# Two roots, one local and one representing some remote orderly location:
local <- orderly_example()
remote <- orderly_example()
orderly_location_add_path("remote", remote, root = local)

orderly_location_list(root = local, verbose = TRUE)

# Rename the remote location:
orderly_location_rename("remote", "bob", root = local)
orderly_location_list(root = local, verbose = TRUE)
}
