% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{do_check}
\alias{do_check}
\title{Perform a check}
\usage{
do_check(
  df,
  v_vars,
  check,
  label_check,
  template_ok = "all variables are {label_check}",
  template_fail = "{var} is not {label_check}"
)
}
\arguments{
\item{df}{a dataframe.}

\item{v_vars}{character vector of variables on which to apply the test.}

\item{check}{a function to apply to the `vars`.}

\item{label_check}{character string. Text describing the test to pass.}

\item{template_ok}{character string. Text to display when a test is passed by a variable.}

\item{template_fail}{character string. Text to display when a test is not passed by a variable.}
}
\value{
List containing the results of the check (checks), and a tibble
of status and message for each test (messages).
The list of messages in the result contains a single line if the test passed,
or if a test failed for one or more variables, a line for each failure.
}
\description{
Checks whether variables fulfill a specific test.
}
\examples{
data(df_pa)
do_check(df = df_pa,
         v_vars = c("u_pfs", "u_pd"),
         check = ~ .x >= 0,
         label_check = "positive"
         )
}
