% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_lasso.R
\name{fit_lasso_metamodel}
\alias{fit_lasso_metamodel}
\title{Fit LASSO metamodel}
\usage{
fit_lasso_metamodel(
  df,
  y_var = NULL,
  x_vars = NULL,
  seed_num = 1,
  standardise = FALSE,
  tune_plot = TRUE,
  x_poly_2 = NULL,
  x_poly_3 = NULL,
  x_exp = NULL,
  x_log = NULL,
  x_inter = NULL
)
}
\arguments{
\item{df}{a dataframe.}

\item{y_var}{character. Name of the output variable in the dataframe. This will be the dependent variable of the metamodel.}

\item{x_vars}{character or a vector for characters. Name of the input variable(s) in the dataframe. This will be the independent variable of the metamodel.}

\item{seed_num}{numeric. Determine which seed number to use to split the dataframe in fitting an validation sets.}

\item{standardise}{logical. Determine whether the parameter of the linear regression should be standardised. Default is FALSE.}

\item{tune_plot}{logical. Determine whether the plot of the results of tuning the lambda should be shown.}

\item{x_poly_2}{character. character or a vector for characters. Name of the input variable in the dataframe. These variables will be exponentiated by factor 2.}

\item{x_poly_3}{character. character or a vector for characters. Name of the input variable in the dataframe. These variables will be exponentiated by factor 3.}

\item{x_exp}{character. character or a vector for characters. Name of the input variable in the dataframe. The exponential of these variables will be included in the metamodel.}

\item{x_log}{character. character or a vector for characters. Name of the input variable in the dataframe. The logarithm of these variables will be included in the metamodel.}

\item{x_inter}{character. character or a vector for characters. Name of the input variables in the dataframe. This vector contains the variables for which the interaction should be considered. The interaction terms of two consecutive variables will be considered in the linear model; hence, the length of this vector should be even.}
}
\value{
A list contaning the following elements:
 \itemize{
   \item An object of the fitted metamodel,
   \item The coefficient of the fitted metamodel,
   \item information on the data used to fit the metamodel and its form.}
}
\description{
This function fits a lasso metamodel using the \code{\link[glmnet]{glmnet}} package.
}
\examples{
#Fit lasso metamodel with two variables using the probabilistic data
data(df_pa)
fit_lasso_metamodel(df = df_pa,
                 y_var = "inc_qaly",
                 x_vars = c("p_pfsd", "p_pdd"),
                 tune_plot = TRUE
                 )

}
