% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_live.R
\name{submit_gemini_pairs_live}
\alias{submit_gemini_pairs_live}
\title{Live Google Gemini comparisons for a tibble of pairs}
\usage{
submit_gemini_pairs_live(
  pairs,
  model,
  trait_name,
  trait_description,
  prompt_template = set_prompt_template(),
  api_key = NULL,
  thinking_level = c("low", "medium", "high"),
  temperature = NULL,
  top_p = NULL,
  top_k = NULL,
  max_output_tokens = NULL,
  api_version = "v1beta",
  verbose = TRUE,
  status_every = 1L,
  progress = TRUE,
  include_raw = FALSE,
  include_thoughts = FALSE,
  ...
)
}
\arguments{
\item{pairs}{Tibble/data frame with columns \code{ID1}, \code{text1}, \code{ID2}, \code{text2}.}

\item{model}{Gemini model name (e.g. \code{"gemini-3-pro-preview"}).}

\item{trait_name}{Trait name.}

\item{trait_description}{Trait description.}

\item{prompt_template}{Prompt template string, typically from
\code{\link[=set_prompt_template]{set_prompt_template()}}.}

\item{api_key}{Optional Gemini API key.}

\item{thinking_level}{Default \code{"low"}; see \code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}}.}

\item{temperature}{Optional numeric temperature; forwarded to
\code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}}. See Gemini docs; if \code{NULL} (default), the
model uses its own default.}

\item{top_p}{Optional numeric; forwarded to \code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}}.}

\item{top_k}{Optional numeric; forwarded to \code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}}.}

\item{max_output_tokens}{Optional integer; forwarded to
\code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}}.}

\item{api_version}{API version; default \code{"v1beta"}.}

\item{verbose}{Logical; print status/timing every \code{status_every} pairs.}

\item{status_every}{Integer; how often to print status (default 1 = every
pair).}

\item{progress}{Logical; show a text progress bar.}

\item{include_raw}{Logical; include \code{raw_response} list-column.}

\item{include_thoughts}{Logical; if \code{TRUE}, requests explicit reasoning
output from Gemini and stores it in the \code{thoughts} column of the result,
mirroring \code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}}.}

\item{...}{Reserved for future extensions; passed through to
\code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}} (but \code{thinking_budget} is ignored there).}
}
\value{
A tibble of results (one row per pair).
}
\description{
This is a thin row-wise wrapper around \code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}}. It takes
a tibble of pairs (\code{ID1} / \code{text1} / \code{ID2} / \code{text2}), submits each pair to
Gemini 3 Pro, and binds the results into a single tibble.
}
\details{
The output has one row per pair and the same columns as
\code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}}, making it easy to pass into downstream
Bradley-Terry / BTM pipelines.
}
\examples{
# Requires:
# - GEMINI_API_KEY set in your environment
# - Internet access
# - Billable Gemini API usage
\dontrun{
# Example pair data
pairs <- tibble::tibble(
  ID1   = c("S01", "S03"),
  text1 = c("Text 1", "Text 3"),
  ID2   = c("S02", "S04"),
  text2 = c("Text 2", "Text 4")
)

td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

# Submit multiple live Gemini comparisons
res <- submit_gemini_pairs_live(
  pairs             = pairs,
  model             = "gemini-3-pro-preview",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl,
  thinking_level    = "low",
  include_thoughts  = FALSE,
  progress          = TRUE
)

res
res$better_id
}

}
