% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partyfacts.R
\name{get_party_color_by_name}
\alias{get_party_color_by_name}
\title{Get party color by name}
\usage{
get_party_color_by_name(
  party_name,
  country = NULL,
  all_colors = FALSE,
  data = NULL
)
}
\arguments{
\item{party_name}{A character string with the party name to search for.}

\item{country}{Optional. ISO 3-letter country code to filter results.}

\item{all_colors}{Logical. If `TRUE`, returns all colors. Default is `FALSE`.}

\item{data}{Optional. A Partyfacts dataset.}
}
\value{
If exactly one party is found, returns the color(s). If multiple
  parties match, returns a tibble with party info and colors. Returns NA
  if no party is found.
}
\description{
A convenience function that combines party lookup and color extraction.
Searches for a party by name, finds its Wikipedia URL, and extracts the
party color.
}
\examples{
\donttest{
if (curl::has_internet()) {
  # Get color for German SPD
  get_party_color_by_name("SPD", country = "DEU")

  # Search more broadly
  get_party_color_by_name("Labour", country = "GBR")
}
}
}
