% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{pathling_read_bundles}
\alias{pathling_read_bundles}
\title{Create a data source from FHIR bundles}
\usage{
pathling_read_bundles(pc, path, resource_types, mime_type = MimeType$FHIR_JSON)
}
\arguments{
\item{pc}{The PathlingContext object.}

\item{path}{The URI of the directory containing the bundles.}

\item{resource_types}{A sequence of resource type codes that should be extracted from the bundles.}

\item{mime_type}{The MIME type of the bundles. Defaults to "application/fhir+json".}
}
\value{
A DataSource object that can be used to run queries against the data.
}
\description{
Creates a data source from a directory containing FHIR bundles.
}
\examples{
\dontrun{
data_source <- pc \%>\% pathling_read_bundles(
  pathling_examples("bundle-xml"),
  c("Patient", "Observation"), MimeType$FHIR_XML
)
data_source \%>\%
  ds_read("Observation") \%>\%
  sparklyr::sdf_nrow()
}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/io#fhir-bundles}{Pathling documentation - Reading Bundles}

Other data source functions: 
\code{\link{pathling_read_bulk}()},
\code{\link{pathling_read_datasets}()},
\code{\link{pathling_read_delta}()},
\code{\link{pathling_read_ndjson}()},
\code{\link{pathling_read_parquet}()},
\code{\link{pathling_read_tables}()}
}
\concept{data source functions}
