% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udfs.R
\name{tx_display}
\alias{tx_display}
\title{Get the display text for codings}
\usage{
tx_display(coding, accept_language = NULL)
}
\arguments{
\item{coding}{A Column containing a struct representation of a Coding.}

\item{accept_language}{The optional language preferences for the returned display name.
Overrides the parameter `accept_language` in \code{\link{pathling_connect}}.}
}
\value{
A Column containing the result of the operation (String).
}
\description{
Takes a Coding column as its input. Returns a Column that contains the canonical display
name associated with the given code.
}
\examples{
\dontrun{
# Get the display name of the first coding of the Condition resource, with the default language.
pc \%>\%
  pathling_example_resource("Condition") \%>\%
  sparklyr::mutate(
    id,
    display = !!tx_display(code[["coding"]][[0]]),
    .keep = "none"
  )
}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/terminology#multi-language-support}{Pathling documentation - Multi-language support}

Other terminology functions: 
\code{\link{tx_member_of}()},
\code{\link{tx_property_of}()},
\code{\link{tx_subsumed_by}()},
\code{\link{tx_subsumes}()},
\code{\link{tx_translate}()}
}
\concept{terminology functions}
