% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{grid_inner}
\alias{grid_inner}
\title{Inner function for grid search}
\usage{
grid_inner(
  hyp_ncs,
  y_hat,
  ncs,
  pos_vals,
  alpha,
  ncs_type,
  distance_weighted_cp,
  distance_features_calib,
  distance_features_pred,
  distance_type,
  normalize_distance,
  weight_function
)
}
\arguments{
\item{hyp_ncs}{vector of hypothetical non-conformity scores}

\item{y_hat}{predicted value}

\item{ncs}{vector of non-conformity scores}

\item{pos_vals}{vector of possible values for the lower and upper bounds of the prediction interval}

\item{alpha}{confidence level}

\item{ncs_type}{type of non-conformity score}

\item{distance_weighted_cp}{logical. If TRUE, the non-conformity scores will be weighted according to the distance function}

\item{distance_features_calib}{a matrix of features for the calibration partition. Used when distance_weighted_cp is TRUE}

\item{distance_features_pred}{a matrix of features for the prediction partition. Used when distance_weighted_cp is TRUE}

\item{distance_type}{The type of distance metric to use when computing distances between calibration and prediction points. Options are 'mahalanobis' and 'euclidean'.}

\item{normalize_distance}{Either 'minmax', 'sd', or 'none'. Indicates how to normalize the distances when distance_weighted_cp is TRUE}

\item{weight_function}{a function to use for weighting the distances. Can be 'gaussian_kernel', 'caucy_kernel', 'logistic', or 'reciprocal_linear'. Default is 'gaussian_kernel'}
}
\value{
a numeric vector with the predicted value and the lower and upper bounds of the prediction interval
}
\description{
Inner function for grid search
}
