\name{lpredprob.GP}
\alias{lpredprob.GP}
\alias{lpredprob.CGP}
\alias{lpredprob.ConstGP}
\title{
  Log-Predictive Probability Calculation for GPs
}
\description{
  Log-predictive probability calculation for Gaussian process (GP)
  regression, classification, or combined unknown constraint
  models; primarily to be used particle learning (PL) re-sample step
}
\usage{
lpredprob.GP(z, Zt, prior)
lpredprob.CGP(z, Zt, prior)
lpredprob.ConstGP(z, Zt, prior)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{z}{
    new observation whose (log) predictive probability is to be
    calculated given the particle \code{Zt}
  }
  \item{Zt}{
    the particle describing model parameters and sufficient statistics
    that determines the predictive distribution
  }
  \item{prior}{
    prior parameters passed from \code{\link{PL}} generated by one of
    the prior functions, e.g., \code{\link{prior.GP}}
  }
}
\details{
  This is the workhorse of the \code{\link{PL}} re-sample step.  For
  each new observation (in sequence), the
  \code{\link{PL}} function calls \code{lpredprob} and these values
  determine the weights used in the \code{\link{sample}} function to
  obtain the new particle set, which is then propagated, e.g., using
  \code{\link{propagate.GP}}

  The \code{\link{lpredprob.ConstGP}} is essentially the combination
  (product) of \code{\link{lpredprob.GP}} and
  \code{\link{lpredprob.CGP}} for regression and classification GP
  models, respectively
}
\value{
  Returns a real-valued scalar - the log predictive probability
}
\references{

 Gramacy, R. and Polson, N. (2011).
  \dQuote{Particle learning of Gaussian process models for
    sequential design and optimization.}
  Journal of Computational and Graphical Statistics, 20(1), 
  pp. 102-118; arXiv:0909.5262

  Gramacy, R. and Lee, H. (2010).
  \dQuote{Optimization under unknown constraints}.
  \emph{Bayesian Statistics 9}, J. M. Bernardo, M. J. Bayarri,
  J. O. Berger, A. P. Dawid, D. Heckerman, A. F. M. Smith and M. West
  (Eds.); Oxford University Press

  Gramacy, R. (2020).
  \dQuote{Surrogates: Gaussian Process Modeling, Design and Optimization for the Applied Sciences}.
  Chapman Hall/CRC; \url{https://bobby.gramacy.com/surrogates/}

  \url{https://bobby.gramacy.com/r_packages/plgp/}
}
\author{
Robert B. Gramacy, \email{rbg@vt.edu}
}

\seealso{
  \code{\link{PL}}, \code{\link{propagate.GP}}
}
\examples{
## See the demos via demo(package="plgp") and the examples
## section of ?plgp
}
\keyword{models}
\keyword{regression}
\keyword{methods}
