% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{logLik.pmrm_fit}
\alias{logLik.pmrm_fit}
\title{Extract the log likelihood.}
\usage{
\method{logLik}{pmrm_fit}(object, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"pmrm_fit"}.}

\item{...}{Not used.}
}
\value{
Numeric scalar, the maximized log likelihood of the fitted model.
}
\description{
Extract the maximized log likelihood of a progression model
for repeated measures (PMRM).
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  logLik(fit)
}
\seealso{
Other model comparison: 
\code{\link{AIC.pmrm_fit}()},
\code{\link{BIC.pmrm_fit}()},
\code{\link{confint.pmrm_fit}()},
\code{\link{deviance.pmrm_fit}()},
\code{\link{glance.pmrm_fit}()},
\code{\link{summary.pmrm_fit}()}
}
\concept{model comparison}
