% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conformal_infer_quantile.R
\name{int_conformal_quantile}
\alias{int_conformal_quantile}
\alias{int_conformal_quantile.workflow}
\title{Prediction intervals via conformal inference and quantile regression}
\usage{
int_conformal_quantile(object, ...)

\method{int_conformal_quantile}{workflow}(object, train_data, cal_data, level = 0.95, ...)
}
\arguments{
\item{object}{A fitted \code{\link[workflows:workflow]{workflows::workflow()}} object.}

\item{...}{Options to pass to \code{\link[quantregForest:quantregForest]{quantregForest::quantregForest()}} (such as the
number of trees).}

\item{train_data, cal_data}{Data frames with the \emph{predictor and outcome data}.
\code{train_data} should be the same data used to produce \code{object} and \code{cal_data} is
used to produce predictions (and residuals). If the workflow used a recipe,
these should be the data that were inputs to the recipe (and not the product
of a recipe).}

\item{level}{The confidence level for the intervals.}
}
\value{
An object of class \code{"int_conformal_quantile"} containing the
information to create intervals (which includes \code{object}).
The \code{predict()} method is used to produce the intervals.
}
\description{
Nonparametric prediction intervals can be computed for fitted regression
workflow objects using the split conformal inference method described by
Romano \emph{et al} (2019). To compute quantiles, this function uses Quantile
Random Forests instead of classic quantile regression.
}
\details{
Note that the significance level should be specified in this function
(instead of the \code{predict()} method).

\code{cal_data} should be large enough to get a good estimates of a extreme
quantile (e.g., the 95th for 95\% interval) and should not include rows that
were in the original training set.

Note that the because of the method used to construct the interval, it is
possible that the prediction intervals will not include the predicted value.
}
\examples{
\dontshow{if (!probably:::is_cran_check() & rlang::is_installed(c("modeldata", "parsnip", "quantregForest"))) withAutoprint(\{ # examplesIf}
library(workflows)
library(dplyr)
library(parsnip)
library(rsample)
library(tune)
library(modeldata)

set.seed(2)
sim_train <- sim_regression(500)
sim_cal <- sim_regression(200)
sim_new <- sim_regression(5) |> select(-outcome)

# We'll use a neural network model
mlp_spec <-
  mlp(hidden_units = 5, penalty = 0.01) |>
  set_mode("regression")

mlp_wflow <-
  workflow() |>
  add_model(mlp_spec) |>
  add_formula(outcome ~ .)

mlp_fit <- fit(mlp_wflow, data = sim_train)

mlp_int <- int_conformal_quantile(mlp_fit, sim_train, sim_cal,
  level = 0.90
)
mlp_int

predict(mlp_int, sim_new)
\dontshow{\}) # examplesIf}
}
\references{
Romano, Yaniv, Evan Patterson, and Emmanuel Candes. "Conformalized quantile
regression." \emph{Advances in neural information processing systems} 32 (2019).
}
\seealso{
\code{\link[=predict.int_conformal_quantile]{predict.int_conformal_quantile()}}
}
