% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{calc_rmd}
\alias{calc_rmd}
\title{Calculate restricted mean durations}
\usage{
calc_rmd(Tw, type = NA, spec = NA, survobj = NULL)
}
\arguments{
\item{Tw}{is the time horizon (weeks) over which the mean should be calculated.}

\item{type}{is either "par" for regular parametric form (exponential, weibull etc) or "spl" for Royston-Parmar splines.}

\item{spec}{is a list comprising:
If type=="par": \code{dist} is the statistical distribution (named per \link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg}) and \code{pars} is a vector of the parameters for that distribution.
\itemize{
\item Exponential distribution (\code{exp}) requires the rate parameter.
\item Weibull distribution (both \code{weibullPH} and \code{weibull} formulations) requires the shape and scale parameters.
\item Log-logistic distribution (\code{llogis}) requires the shape and scale parameters.
\item Log-normal distribution (\code{lnorm}) requires the meanlog and sdlog parameters.
\item Gamma and Gompertz distributions (\code{gamma} and \code{gompertz}) require the shape and rate parameters.
\item Generalized Gamma requires the mu, sigma and Q parameters if using the standard parameterization (\code{gengamma}) or shape, scale and k parameters if using the original parameterization (\code{gengamma.orig}).
If type=="spl":
\item \code{gamma} - Vector of parameters describing the baseline spline function, as described in \link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline}. This may be supplied as a vector with number of elements equal to the length of knots, in which case the parameters are common to all times. Alternatively a matrix may be supplied, with rows corresponding to different times, and columns corresponding to knots.
\item \code{knots} - Vector of locations of knots on the axis of log time, supplied in increasing order. Unlike in \link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline}, these include the two boundary knots.
\item \code{scale} - Either "hazard", "odds", or "normal", as described in \link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline}. With the default of no knots in addition to the boundaries, this model reduces to the Weibull, log-logistic and log-normal respectively. The scale must be common to all times.
}}

\item{survobj}{is a survival fit object from \link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline} or \link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg}}
}
\value{
the restricted mean duration, a numeric value.
}
\description{
Calculates the restricted mean duration, given the form of a parametric distribution of Royston-Parmar splines
}
\examples{
calc_rmd(Tw=200,
    type="spl",
    spec=list(gamma=c(0.1,0.2,0.1), knots=c(-5,2,4), scale="normal")
    )
calc_rmd(Tw=250,
    type="par",
    spec=list(dist="lnorm", pars=c(3,1))
    )
}
