% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_powerprior_watt.R
\name{psrwe_powerp_watt}
\alias{psrwe_powerp_watt}
\title{Get posterior samples based on PS-power prior approach (WATT)}
\usage{
psrwe_powerp_watt(
  dta_psbor,
  v_outcome = "Y",
  outcome_type = c("continuous", "binary"),
  mcmc_method = c("rstan", "analytic", "wattcon"),
  tau0_method = c("Wang2019", "weighted"),
  ipw_method = c("Heng.Li", "Xi.Ada.Wang"),
  ...,
  seed = NULL
)
}
\arguments{
\item{dta_psbor}{A class \code{PSRWE_BOR} object generated by
\code{\link{psrwe_borrow}}.}

\item{v_outcome}{Column name corresponding to the outcome.}

\item{outcome_type}{Type of outcomes: \code{continuous} or \code{binary}.}

\item{mcmc_method}{MCMC sampling via either \code{rstan}, \code{analytic},
or \code{wattcon}.}

\item{tau0_method}{Method for estimating SD0 via either \code{Wang2019} or
\code{weighted} for continuous outcomes only.}

\item{ipw_method}{Method for IPW via either \code{Heng.Li} or
\code{Xi.Ada.Wang}.}

\item{...}{extra parameters for calling function \code{\link{rwe_stan}}.}

\item{seed}{Random seed.}
}
\value{
A class \code{PSRWE_RST} list with the following objects

\describe{
    \item{Observed}{Observed mean and SD of the outcome by group, arm
    and stratum}

    \item{Control}{A list of estimated mean and SD of the outcome by stratum
    in the control arm}

    \item{Treatment}{A list of estimated mean and SD of the outcome by
    stratum in the treatment arm for RCT}

    \item{Effect}{A list of estimated mean and SD of the treatment effect by
    stratum for RCT}

    \item{Borrow}{Borrowing information from \code{dta_psbor}}

    \item{stan_rst}{Result from STAN sampling}
}
}
\description{
Draw posterior samples of the parameters of interest for the PS-power prior
approach with weights of ATT (WATT)
}
\examples{

\donttest{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current",
       nstrata = 1)
ps_borrow <- psrwe_borrow(total_borrow = 30, dta_ps)
rst <- psrwe_powerp_watt(ps_borrow, v_outcome = "Y_Bin", seed = 123)}

}
