% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_bddk.R
\name{fetch_bddk1}
\alias{fetch_bddk1}
\title{Fetch Monthly Data from BDDK with Multiple Group Codes}
\usage{
fetch_bddk1(
  year,
  month,
  table_no,
  grup_kod = 10001,
  currency = "TL",
  lang = "en"
)
}
\arguments{
\item{year}{Year as 4-digit integer (YYYY).}

\item{month}{Month as integer (1-12).}

\item{table_no}{Table number to fetch (1-17). No default.
Use \code{\link{list_tables}} with \code{source = "bddk"} to see available options.}

\item{grup_kod}{Group code (10001-10010). Default 10001.
Use \code{\link{list_groups}} with \code{source = "bddk"} to see available options.}

\item{currency}{Currency code ("TL" or "USD"). Default "TL".}

\item{lang}{Language ("en" or "tr"). Default "en".}
}
\value{
Data frame with a \code{fetch_info} attribute that contains query details.
}
\description{
Retrieves monthly banking data from the BDDK API for specified group codes.
Supports multiple group codes in a single request, returning a combined
data frame with consistent numeric \code{grup_kod} values.
}
\examples{
# Single group code
fetch_bddk1(2020, 3, 1, grup_kod = 10001)

# Multiple group codes
fetch_bddk1(2020, 3, 1, grup_kod = c(10001, 10002))

# Turkish language output
fetch_bddk1(2020, 3, 1, grup_kod = 10001, lang = "tr")

}
\seealso{
\code{\link[=fetch_finturk1]{fetch_finturk1()}} for quarterly province-level data.
}
