% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smiles.R
\name{get.smiles}
\alias{get.smiles}
\title{Generate a SMILES representation of a molecule.}
\usage{
get.smiles(molecule, flavor = smiles.flavors(c("Generic")), smigen = NULL)
}
\arguments{
\item{molecule}{The molecule to query. Should be a `jobjRef` representing an `IAtomContainer`}

\item{flavor}{The type of SMILES to generate. See \code{\link{smiles.flavors}}. Default is `Generic`
SMILES}

\item{smigen}{A pre-existing SMILES generator object. By default, a new one is created from the specified flavor}
}
\value{
A character string containing the generated SMILES
}
\description{
The function will generate a SMILES representation of an
`IAtomContainer` object. The default parameters of the CDK SMILES
generator are used. This can mean that for large ring systems the
method may fail. See CDK \href{https://cdk.github.io/cdk/2.10/docs/api/org/openscience/cdk/smiles/SmilesGenerator.html}{Javadocs}
for more information
}
\examples{
m <- parse.smiles('C1C=CCC1N(C)c1ccccc1')[[1]]
get.smiles(m)
get.smiles(m, smiles.flavors(c('Generic','UseAromaticSymbols')))
}
\references{
\href{https://cdk.github.io/cdk/2.10/docs/api/org/openscience/cdk/smiles/SmilesGenerator.html}{SmilesGenerator}
}
\seealso{
\code{\link{parse.smiles}}, \code{\link{smiles.flavors}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
