% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smiles.R
\name{smiles.flavors}
\alias{smiles.flavors}
\title{Generate flag for customizing SMILES generation.}
\usage{
smiles.flavors(flavors = c("Generic"))
}
\arguments{
\item{flavors}{A character vector of flavors. The default is \code{Generic}
(output non-canonical SMILES without stereochemistry, atomic masses). Possible
values are
\itemize{
\item Absolute
\item AtomAtomMap
\item AtomicMass
\item AtomicMassStrict
\item Canonical
\item Cx2dCoordinates
\item Cx3dCoordinates
\item CxAtomLabel
\item CxAtomValue
\item CxCoordinates
\item CxFragmentGroup
\item CxMulticenter
\item CxPolymer
\item CxRadical
\item CxSmiles
\item CxSmilesWithCoords
\item Default
\item Generic
\item InChILabelling
\item Isomeric
\item Stereo
\item StereoCisTrans
\item StereoExTetrahedral
\item StereoTetrahedral
\item Unique
\item UniversalSmiles
\item UseAromaticSymbols
}}
}
\value{
A numeric representing the bitwise `OR`` of the specified flavors
}
\description{
The CDK supports a variety of customizations for SMILES generation including
the use of lower case symbols for aromatic compounds to the use of the ChemAxon
\href{https://docs.chemaxon.com/display/docs/formats_chemaxon-extended-smiles-and-smarts-cxsmiles-and-cxsmarts.md}{CxSmiles}
format. Each 'flavor' is represented by an integer and multiple
customizations are bitwise OR'ed. This method accepts the names of one or
more customizations and returns the bitwise OR of them.
See \href{https://cdk.github.io/cdk/2.10/docs/api/index.html?org/openscience/cdk/smiles/SmiFlavor.html}{CDK documentation}
for the list of flavors and what they mean.
}
\examples{
m <- parse.smiles('C1C=CCC1N(C)c1ccccc1')[[1]]
get.smiles(m)
get.smiles(m, smiles.flavors(c('Generic','UseAromaticSymbols')))

m <- parse.smiles("OS(=O)(=O)c1ccc(cc1)C(CC)CC |Sg:n:13:m:ht,Sg:n:11:n:ht|")[[1]]
get.smiles(m,flavor = smiles.flavors(c("CxSmiles")))
get.smiles(m,flavor = smiles.flavors(c("CxSmiles","UseAromaticSymbols")))

}
\references{
\href{https://cdk.github.io/cdk/2.10/docs/api/index.html?org/openscience/cdk/smiles/SmiFlavor.html}{CDK documentation}
}
\seealso{
\code{\link{get.smiles}}
}
\author{
Rajarshi Guha \email{rajarshi.guha@gmail.com}
}
